// Generated by CoffeeScript 1.7.1
(function() {
  var EventEmitter, IDWeakMap, ObjectsRegistry, ObjectsStore, v8Util,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  EventEmitter = require('events').EventEmitter;

  IDWeakMap = require('id-weak-map');

  v8Util = process.atomBinding('v8_util');

  ObjectsStore = (function() {
    ObjectsStore.stores = {};

    function ObjectsStore() {
      this.nextId = 0;
      this.objects = [];
    }

    ObjectsStore.prototype.getNextId = function() {
      return ++this.nextId;
    };

    ObjectsStore.prototype.add = function(obj) {
      var id;
      id = this.getNextId();
      this.objects[id] = obj;
      return id;
    };

    ObjectsStore.prototype.has = function(id) {
      return this.objects[id] != null;
    };

    ObjectsStore.prototype.remove = function(id) {
      if (!this.has(id)) {
        throw new Error("Invalid key " + id + " for ObjectsStore");
      }
      return delete this.objects[id];
    };

    ObjectsStore.prototype.get = function(id) {
      if (!this.has(id)) {
        throw new Error("Invalid key " + id + " for ObjectsStore");
      }
      return this.objects[id];
    };

    ObjectsStore.forRenderView = function(key) {
      if (this.stores[key] == null) {
        this.stores[key] = new ObjectsStore;
      }
      return this.stores[key];
    };

    ObjectsStore.releaseForRenderView = function(key) {
      return delete this.stores[key];
    };

    return ObjectsStore;

  })();

  ObjectsRegistry = (function(_super) {
    __extends(ObjectsRegistry, _super);

    function ObjectsRegistry() {
      this.setMaxListeners(Number.MAX_VALUE);
      this.objectsWeakMap = new IDWeakMap;
      this.objectsWeakMap.add = function(obj) {
        var id;
        id = IDWeakMap.prototype.add.call(this, obj);
        v8Util.setHiddenValue(obj, 'atomId', id);
        return id;
      };
    }

    ObjectsRegistry.prototype.add = function(key, obj) {
      var id, store, storeId;
      if (!v8Util.getHiddenValue(obj, 'atomId')) {
        this.objectsWeakMap.add(obj);
      }
      id = v8Util.getHiddenValue(obj, 'atomId');
      store = ObjectsStore.forRenderView(key);
      storeId = store.add(obj);
      return [id, storeId];
    };

    ObjectsRegistry.prototype.get = function(id) {
      return this.objectsWeakMap.get(id);
    };

    ObjectsRegistry.prototype.remove = function(key, storeId) {
      return ObjectsStore.forRenderView(key).remove(storeId);
    };

    ObjectsRegistry.prototype.clear = function(key) {
      this.emit("clear-" + key);
      return ObjectsStore.releaseForRenderView(key);
    };

    return ObjectsRegistry;

  })(EventEmitter);

  module.exports = new ObjectsRegistry;

}).call(this);
